package gov.va.caret.service.vetscanner;

import java.text.SimpleDateFormat;
import java.util.Date;

import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ClassNameLocalServiceUtil;

import gov.va.caret.model.Persn;
import gov.va.caret.model.WorIm;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.WorImLocalServiceUtil;
import gov.va.caret.service.ctssh.ServiceFacade;

public class VetScanWorker implements Runnable {

	private static SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
	private String _dod;
	private Persn _caret_person;
	

	
	public VetScanWorker(Persn caret_person) {
		_caret_person = caret_person;
	}
	
	protected Persn getPerson()
	{
		return _caret_person;
	}
	
	public void run()
	{
		try{
			//do E&E Service call
			_dod = ServiceFacade.EEDodSearch(_caret_person.getICN());
			
			
			
			
			if(_dod != null)
			{
				System.out.println("VetScanner--->DOD returned for Veteran (persnid:" + _caret_person.getPersnId() + ",userid:" + _caret_person.getUserId() + ")");	
				
				if(_dod.length() > 10)
					_dod = _dod.substring(0,10);
				
				System.out.println("VetScanner--->DOD for Veteran (persnid:" + _caret_person.getPersnId() + ",userid:" + _caret_person.getUserId() + ") adjusted to " + _dod);
				
				Date DOD = sdf.parse(_dod);
				_caret_person.setDeceasedDate(DOD);
				PersnLocalServiceUtil.updatePersn(_caret_person);
				//create a work item in the Tech queueu
				 long caret_workitem_id = CounterLocalServiceUtil.increment(WorIm.class.getName());
				 WorIm caret_work_item = WorImLocalServiceUtil.createWorIm(caret_workitem_id);
				 caret_work_item.setType("VETERAN DOD ASSIGNED");
				 caret_work_item.setClassId(ClassNameLocalServiceUtil.getClassNameId(User.class));
				 caret_work_item.setClassPk(_caret_person.getUserId());
				 caret_work_item.setStatus("NEW");
				 caret_work_item.setCreationDate(new Date());
				 caret_work_item.setPersnId(_caret_person.getPersnId());
				 WorImLocalServiceUtil.addWorIm(caret_work_item);				
				
				
				 System.out.println("VetScanner--->Processing for Veteran (persnid:" + _caret_person.getPersnId() + ",userid:" + _caret_person.getUserId() + ") complete");				
				
				
				
				
			}
			
		}catch(Exception er)
		{
			System.out.println("VetScanner--->Processing for Veteran (persnid:" + _caret_person.getPersnId() + ",userid:" + _caret_person.getUserId() + ") complete");
			System.out.println("VETSCANNER--->EXCEPTION PROCESSING VET DOD FOR VETERAN(PERSNID:" + _caret_person.getPersnId() + ",USERID:" + _caret_person.getUserId() + "): " + er.getMessage());
		}
	
	}
	
	
}
